unit fSimpleSearch;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, DBGrids, Mask, DBCtrls, uEstSearchDialog,
  uEstSearchDialogAdo, DB, dMain, ADODB;

type
  TFrmSimpleSearch = class(TForm)
    dtsCustomer: TDataSource;
    dtsOrders: TDataSource;
    esdOrders: TEstSearchDialogAdo;
    esdCustomer: TEstSearchDialogAdo;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    DBEdit1: TDBEdit;
    DBEdit2: TDBEdit;
    DBEdit3: TDBEdit;
    DBEdit4: TDBEdit;
    DBEdit5: TDBEdit;
    DBEdit6: TDBEdit;
    DBEdit7: TDBEdit;
    DBEdit8: TDBEdit;
    DBEdit9: TDBEdit;
    DBEdit10: TDBEdit;
    DBEdit11: TDBEdit;
    DBEdit12: TDBEdit;
    DBEdit13: TDBEdit;
    DBGrid1: TDBGrid;
    btnSearchCustomer: TButton;
    btnSearchOrder: TButton;
    mmoSimpleSearch: TMemo;
    qryCustomer: TADODataSet;
    qryOrders: TADODataSet;
    qryCustomerCustNo: TFloatField;
    qryCustomerCompany: TWideStringField;
    qryCustomerAddr1: TWideStringField;
    qryCustomerAddr2: TWideStringField;
    qryCustomerCity: TWideStringField;
    qryCustomerState: TWideStringField;
    qryCustomerZip: TWideStringField;
    qryCustomerCountry: TWideStringField;
    qryCustomerPhone: TWideStringField;
    qryCustomerFAX: TWideStringField;
    qryCustomerTaxRate: TFloatField;
    qryCustomerContact: TWideStringField;
    qryCustomerLastInvoiceDate: TDateTimeField;
    qryOrdersOrderNo: TFloatField;
    qryOrdersCustNo: TFloatField;
    qryOrdersSaleDate: TDateTimeField;
    qryOrdersShipDate: TDateTimeField;
    qryOrdersEmpNo: TIntegerField;
    qryOrdersShipToContact: TWideStringField;
    qryOrdersShipToAddr1: TWideStringField;
    qryOrdersShipToAddr2: TWideStringField;
    qryOrdersShipToCity: TWideStringField;
    qryOrdersShipToState: TWideStringField;
    qryOrdersShipToZip: TWideStringField;
    qryOrdersShipToCountry: TWideStringField;
    qryOrdersShipToPhone: TWideStringField;
    qryOrdersShipVIA: TWideStringField;
    qryOrdersPO: TWideStringField;
    qryOrdersTerms: TWideStringField;
    qryOrdersPaymentMethod: TWideStringField;
    qryOrdersItemsTotal: TFloatField;
    qryOrdersTaxRate: TFloatField;
    qryOrdersFreight: TFloatField;
    qryOrdersAmountPaid: TFloatField;
    procedure btnSearchCustomerClick(Sender: TObject);
    procedure btnSearchOrderClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

implementation

{$R *.dfm}

procedure TFrmSimpleSearch.btnSearchCustomerClick(Sender: TObject);
begin
  // NL: Zoek klant
  // EN: Search customer
  if esdCustomer.Execute then
  begin

    // NL: Sluit beide queries
    // EN: Close both queries
    qryOrders.Close;
    qryCustomer.Close;

    // NL: Vul parameter van query met gevonden customer
    // EN: Fill query parameter with customer found
    qryCustomer.Parameters.ParamByName('custno').Value := esdCustomer.ResultFieldAsInteger('custno');

    // NL: Open beide queries
    // EN: Open both queries
    qryCustomer.Open;
    qryOrders.Open;
  end;
end;

procedure TFrmSimpleSearch.btnSearchOrderClick(Sender: TObject);
begin
  // NL: Als er nog geen klant geselecteerd is, kan er ook geen order van die klant
  //     gezocht worden
  // EN: If no customer has been selected, no order of that customer can be
  //     searched
  if not qryCustomer.Active then
    raise Exception.Create('Zoek eerst een klant');

  // NL: Stel in dat er alleen gezocht kan worden in de orders van de geselecteerd
  //     klant
  // EN: Set that only orders of the selected customer can be searched
  esdOrders.AdditionalWhere := Format('custno = %d', [qryCustomerCustNo.AsInteger]);

  // NL: Locate de gevonden order
  // EN: Locate the order found
  if esdOrders.Execute then
    qryOrders.Locate('orderno', esdOrders.ResultFieldAsInteger('orderno'), []);
end;

procedure TFrmSimpleSearch.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

end.
